//
//  MeetingSDKWrap.h
//  meetingservice
//
//  Created by wang yong on 5/27/13.
//  Copyright (c) 2013 weifeshe. All rights reserved.
//

#ifndef __meetingservice__MeetingSDKWrap__
#define __meetingservice__MeetingSDKWrap__

#include "autoupgrade/gen_files/meeting_sdk_impl.h"
#include "csfunified/framework/UnifiedFactory.h"
#include <string>

using namespace JM_SDK;

class NetUtilTransport;

namespace CSFUnified {

typedef JMResult (*PFFunctionGet)(const char *pFunctionName, void **pfFunc);

class MeetingSDKWrap
{
public:
    static MeetingSDKWrap* getInstance()
    {
        if(NULL == m_pInstance)
        {
            m_pInstance = new MeetingSDKWrap();
        }
        return m_pInstance;
    }
    
    virtual ~MeetingSDKWrap();
    
private:
    MeetingSDKWrap();
    static MeetingSDKWrap* m_pInstance;
    
public:
    bool loadSDKModule();
    void freeSDKModule();
    
    bool IsSDKLoadSuccessfull()
    {
        return m_bIsSDKLoadSuccessfull;
    }
    
    void createJMSDK(IJabberMeetingSDKDelegate* pDelegate, const FeatureCapability& featureCap)
    {
        setIJabberMeetingSDKDelegate(pDelegate);
        
        m_IJMSDKInstanceImpl.createJMSDK(featureCap.isDesktopShareEnable, featureCap.isMeetingAccountEnable, featureCap.isInstantMeetingEnable, featureCap.isMeetingListEnable);
    }
    
    void deleteJMSDK()
    {
        m_IJMSDKInstanceImpl.deleteJMSDK();
    }
    
    void startMeetingSDK();
    
    void stopMeetingSDK();
    
    void networkChanged(bool bConnected);
    
    void changeCapability(const FeatureCapability& featureCap)
    {
        m_IJMSDKInstanceImpl.ChangeCapability(featureCap.isDesktopShareEnable, featureCap.isMeetingAccountEnable, featureCap.isInstantMeetingEnable, featureCap.isMeetingListEnable);
    }
    
    IDSMgr* getDSMgr()
    {
        return &m_IDSMgrImpl;
    }
    
    IWbxMeetingAccountQuery* getAccountQuery()
    {
        return &m_IWbxMeetingAccountQueryImpl;
    }
    
    IWbxMeetingAccountOperator* getAccountOperator()
    {
        return &m_IWbxMeetingAccountOperatorImpl;
    }
    
    IWbxMeetingAccountValidation* getAccountValidation()
    {
        return &m_IWbxMeetingAccountValidationImpl;
    }
    
    IInstantMeetingMgr* getInstantMeetingMgr()
    {
        return &m_IInstantMeetingMgrImpl;
    }
    
    IMeetingCalendar* getMeetingCalendar()
    {
        return &m_IMeetingCalendarImpl;
    }
    
    void setIJabberMeetingSDKDelegate(IJabberMeetingSDKDelegate* pDelegate)
    {
        m_IJabberMeetingSDKDelegateWrapper.SetHandler(pDelegate);
    }
    
    void setIMeetingCalendarEvent(IMeetingCalendarEvent* pEvent)
    {
        m_IMeetingCalendarEventWrapper.SetHandler(pEvent);
    }
    
    void setIWbxMeetingAccountValidationEvent(IWbxMeetingAccountValidationEvent* pEvent)
    {
        m_IWbxMeetingAccountValidationEventWrapper.SetHandler(pEvent);
    }
    
    void setIDSEvent(IDSEvent* pEvent)
    {
        m_IDSEventWrapper.SetHandler(pEvent);
    }
    
    void setJMLogger(IJMLogger *pLogger)
    {
        m_IJMLoggerWrapper.SetHandler(pLogger);
    }

    void setNetworkTransport(INetworkTransport *pTransport)
    {
       m_INetworkTransportWrapper.SetHandler(pTransport);
    }

    void setUnifiedFactory(SMART_PTR_NS::shared_ptr<UnifiedFactory> unifiedFactory)
    {
        m_unifiedFactory = unifiedFactory;
    }

private:
    JMHandle m_libHandle;
    bool m_bIsSDKLoadSuccessfull;
    
    IDSMgrImpl m_IDSMgrImpl;
    IWbxMeetingAccountQueryImpl m_IWbxMeetingAccountQueryImpl;
    IWbxMeetingAccountOperatorImpl m_IWbxMeetingAccountOperatorImpl;
    IWbxMeetingAccountValidationImpl m_IWbxMeetingAccountValidationImpl;
    IInstantMeetingMgrImpl m_IInstantMeetingMgrImpl;
    IMeetingCalendarImpl m_IMeetingCalendarImpl;
    IJMSDKInstanceImpl m_IJMSDKInstanceImpl;
    IJMLoggerWrapper m_IJMLoggerWrapper;
    INetworkTransportWrapper m_INetworkTransportWrapper;
    
    IJabberMeetingSDKDelegateWrapper m_IJabberMeetingSDKDelegateWrapper;
    IMeetingCalendarEventWrapper m_IMeetingCalendarEventWrapper;
    IWbxMeetingAccountValidationEventWrapper m_IWbxMeetingAccountValidationEventWrapper;
    IDSEventWrapper m_IDSEventWrapper;

    SMART_PTR_NS::shared_ptr<UnifiedFactory> m_unifiedFactory;
    SMART_PTR_NS::shared_ptr<NetUtilTransport> m_MeetingNetUtilTransport;
};
}
#endif /* defined(__meetingservice__MeetingSDKWrap__) */
